function [F, grad, hess] = dblexpconv_fgh(coef, Data, IR);
%fitting function for global fitting algorithm
%convolves the a double exponantial decay (calculated from coefficients
%obtained from coef) with the impulse response (IR).
%F is the qui_square value calculated between the modeled and
%experiomentals decays

global ERR ITER ITER_EVOL T_START FULL_SCALE

Nb_pix = (length(coef)-2)/2;        %Number of pixels
T_points = size(Data,2);    %Number of time points
L_coef = length(coef);
[Tmax, Tmax_i] = max(IR);  %finds Time zero indice
x = Data(1,:);
Y_Data = Data(2:Nb_pix+1,:);
x_ext = [0:T_points+Tmax_i-1].*(x(2) - x(1)) - x(1);
x_ext = x_ext - x_ext(Tmax_i);
A_2D = zeros(Nb_pix, T_points + Tmax_i);


coef_3 = coef(3:2:L_coef-1);
coef_4 = coef(4:2:L_coef);


for i = Tmax_i:T_points+Tmax_i
    A_2D(:,i) = coef_3(:).*(coef_4(:).*exp(-coef(1)*x_ext(i)) + (1-coef_4(:)).*exp(-coef(2)*x_ext(i)));
end

MODEL_2D = conv_2D(A_2D(:,Tmax_i:T_points+Tmax_i), IR);
Square = ((MODEL_2D - Y_Data).^2)./ERR;
F = sum(sum(Square));

grad = 0;
hess = 0;
if FULL_SCALE == 1
    ITER = ITER + 1;
    Dt = cputime - T_START;
    ITER_EVOL(ITER,:) = [Dt, F, coef(1), coef(2)]; 
end

if nargout > 1
    if nargout > 2
        [grad, hess] = hess_dblexpconv(coef, Data, IR, MODEL_2D, ERR);
    else
        grad = grad_dblexpconv(coef, Data, IR, MODEL, ERR); %Not working
        
    end
end


%_________HESSIAN___________________

function [grad, hess] = hess_dblexpconv(c, Data, IR, MODEL, D_err)

L = size(Data,2);       %number of time points
K = size(Data,1)-1;     %Number of pixels
N = 2*K+2;               %number of coefficients

[Tmax, Tmax_i] = max(IR);  %finds Time zero indice

x = Data(1,:);
t = [0:L+Tmax_i-1].*(x(2) - x(1)) - x(1);
t = t - t(Tmax_i);
D = Data(2:K+1,:);

c_3 = c(3:2:N-1);
c_4 = c(4:2:N);

Spare_length = 4*N + 2*(N-4);
S = zeros(Spare_length,1);
I = zeros(Spare_length,1);
J = zeros(Spare_length,1);

dF_1 = zeros(K, L + Tmax_i);
dF_2 = zeros(K, L + Tmax_i);
dF_3 = zeros(K, L + Tmax_i);
dF_4 = zeros(K, L + Tmax_i);

ddF_1_1 = zeros(K, L + Tmax_i);
ddF_1_2 = zeros(K, L + Tmax_i);
ddF_1_3 = zeros(K, L + Tmax_i);
ddF_1_4 = zeros(K, L + Tmax_i);
ddF_2_2 = zeros(K, L + Tmax_i);
ddF_2_3 = zeros(K, L + Tmax_i);
ddF_2_4 = zeros(K, L + Tmax_i);
ddF_3_3 = zeros(K, L + Tmax_i);
ddF_3_4 = zeros(K, L + Tmax_i);
ddF_4_4 = zeros(K, L + Tmax_i);


Diff = (MODEL - D)./D_err;

%_______Calculate 1st and 2nd derivatives_________________
for i = Tmax_i:L+Tmax_i
    dF_1(:,i) = - c_3(:).*c_4(:).*t(i).*exp(-c(1)*t(i));
    dF_2(:,i) = - c_3(:).*t(i).*exp(-c(2)*t(i)) + c_3(:).*c_4(:).*t(i).*exp(-c(2)*t(i));
    dF_3(:,i) = c_4(:).*exp(-c(1)*t(i)) + exp(-c(2)*t(i)) - c_4(:).*exp(-c(2)*t(i));
    dF_4(:,i) =  c_3(:).*exp(-c(1)*t(i)) - c_3(:).*exp(-c(2)*t(i));
    
    ddF_1_1(:,i) = c_3(:).*c_4(:).*t(i)^2.*exp(-c(1)*t(i));
    %ddF_1_2 = zeros;
    ddF_1_3(:,i) = -c_4(:).*t(i).*exp(-c(1)*t(i));
    ddF_1_4(:,i) = -c_3(:).*t(i).*exp(-c(1)*t(i));
    
    ddF_2_2(:,i) = c_3(:).*t(i)^2.*exp(-c(2)*t(i)) - c_3(:).*c_4(:).*t(i)^2.*exp(-c(2).*t(i));
    ddF_2_3(:,i) = -t(i).*exp(-c(2).*t(i)) + c_4(:).*t(i).*exp(-c(2).*t(i));
    ddF_2_4(:,i) = c_3(:).*t(i).*exp(-c(2).*t(i));
    
    %ddF_3_3 = zeros;
    ddF_3_4(:,i) = exp(-c(1).*t(i)) - exp(-c(2).*t(i));
    
    %ddF_4_4 = zeros;
end

%_________Calculates grad___________________

grad = zeros(N,1);

GdF_1 = conv_2D(dF_1(:,Tmax_i:L+Tmax_i), IR);
GdF_2 = conv_2D(dF_2(:,Tmax_i:L+Tmax_i), IR);
GdF_3 = conv_2D(dF_3(:,Tmax_i:L+Tmax_i), IR);
GdF_4 = conv_2D(dF_4(:,Tmax_i:L+Tmax_i), IR);

grad(1,:) = sum(sum(2.*GdF_1.*Diff));
grad(2,:) = sum(sum(2.*GdF_2.*Diff));
grad(3:2:N-1) = sum(2.*GdF_3.*Diff, 2);
grad(4:2:N) = sum(2.*GdF_4.*Diff, 2);

clear dF_1 dF_2 dF_3 dF_4

%________________Calculate Hessian___________________


GddF_1_1 = conv_2D(ddF_1_1(:,Tmax_i:L+Tmax_i), IR);
%GddF_1_2
GddF_1_3 = conv_2D(ddF_1_3(:,Tmax_i:L+Tmax_i), IR);
GddF_1_4 = conv_2D(ddF_1_4(:,Tmax_i:L+Tmax_i), IR);

H_1_1 =sum( sum( 2.*Diff.*GddF_1_1 + 2.*GdF_1.*GdF_1./D_err));
H_1_2 = sum( sum(  2.*GdF_1.*GdF_2./D_err));
H_1_3 = sum( 2.*Diff.*GddF_1_3 + 2.*GdF_1.*GdF_3./D_err, 2);
H_1_4 = sum( 2.*Diff.*GddF_1_4 + 2.*GdF_1.*GdF_4./D_err, 2);

clear ddF_1_1 ddF_1_3 ddF_1_4 GdF_1 GddF_1_1  GddF_1_3  GddF_1_4


GddF_2_2 = conv_2D(ddF_2_2(:,Tmax_i:L+Tmax_i), IR);
GddF_2_3 = conv_2D(ddF_2_3(:,Tmax_i:L+Tmax_i), IR);
GddF_2_4 = conv_2D(ddF_2_4(:,Tmax_i:L+Tmax_i), IR);

H_2_2 = sum( sum( 2.*Diff.*GddF_2_2 + 2.*GdF_2.*GdF_2./D_err));
H_2_3 = sum( 2.*Diff.*GddF_2_3 + 2.*GdF_2.*GdF_3./D_err, 2);
H_2_4 = sum( 2.*Diff.*GddF_2_4 + 2.*GdF_2.*GdF_4./D_err, 2);

clear ddF_2_2 ddF_2_3 ddF_2_4 GdF_2 GddF_2_2  GddF_2_3  GddF_2_4

%GddF_3_3
GddF_3_4 = conv_2D(ddF_3_4(:,Tmax_i:L+Tmax_i), IR);
%GddF_4_4

H_3_3 = sum( 2.*GdF_3.*GdF_3./D_err, 2);
H_3_4 = sum( 2.*Diff.*GddF_3_4 + 2.*GdF_3.*GdF_4./D_err, 2);
H_4_4 = sum( 2.*GdF_4.*GdF_4./D_err, 2);

clear ddF_3_4 GdF_3 GdF_4 GddF_3_4

I(1) = 1;
J(1) = 1;
S(1) = H_1_1;
     
I(2) = 1;
J(2) = 2;
S(2) = H_1_2;
    
I(3) = 2;
J(3) = 1;
S(3) = H_1_2;
     
I(4) = 2;
J(4) = 2;
S(4) = H_2_2;

h = 0;
I(5+K*h:4+K*(h+1)) = 1;
J(5+K*h:4+K*(h+1)) = [3:2:N-1];
S(5+K*h:4+K*(h+1)) = H_1_3;

h = h+1;
I(5+K*h:4+K*(h+1)) = 1;
J(5+K*h:4+K*(h+1)) = [4:2:N];
S(5+K*h:4+K*(h+1)) = H_1_4;

h = h+1;
I(5+K*h:4+K*(h+1)) = 2;
J(5+K*h:4+K*(h+1)) = [3:2:N-1];
S(5+K*h:4+K*(h+1)) = H_2_3;


h = h+1;
I(5+K*h:4+K*(h+1)) = 2;
J(5+K*h:4+K*(h+1)) = [4:2:N];
S(5+K*h:4+K*(h+1)) = H_2_4;

h = h+1;
I(5+K*h:4+K*(h+1)) = [3:2:N-1];
J(5+K*h:4+K*(h+1)) = 1;
S(5+K*h:4+K*(h+1)) = H_1_3;



h = h+1;
I(5+K*h:4+K*(h+1)) = [4:2:N];
J(5+K*h:4+K*(h+1)) = 1;
S(5+K*h:4+K*(h+1)) = H_1_4;


h = h+1;
I(5+K*h:4+K*(h+1)) = [3:2:N-1];
J(5+K*h:4+K*(h+1)) = 2;
S(5+K*h:4+K*(h+1)) = H_2_3;



h = h+1;
I(5+K*h:4+K*(h+1)) = [4:2:N];
J(5+K*h:4+K*(h+1)) = 2;
S(5+K*h:4+K*(h+1)) = H_2_4;

h = h+1;
I(5+K*h:4+K*(h+1)) = [3:2:N-1];
J(5+K*h:4+K*(h+1)) = [3:2:N-1];
S(5+K*h:4+K*(h+1)) = H_3_3;

h = h+1;
I(5+K*h:4+K*(h+1)) = [3:2:N-1];
J(5+K*h:4+K*(h+1)) = [4:2:N];
S(5+K*h:4+K*(h+1)) = H_3_4;

h = h+1;
I(5+K*h:4+K*(h+1)) = [4:2:N];
J(5+K*h:4+K*(h+1)) = [3:2:N-1];
S(5+K*h:4+K*(h+1)) = H_3_4;

h = h+1;
I(5+K*h:4+K*(h+1)) = [4:2:N];
J(5+K*h:4+K*(h+1)) = [4:2:N];
S(5+K*h:4+K*(h+1)) = H_4_4;

hess = sparse(I,J,S,N,N);

% H =
%  
% [                 b*c*x^2*exp(-s*x)]
% [                                 0]
% [                    -c*x*exp(-s*x)]
% [                    -b*x*exp(-s*x)]
% [ b*x^2*exp(-t*x)-b*c*x^2*exp(-t*x)]
% [        -x*exp(-t*x)+c*x*exp(-t*x)]
% [                     b*x*exp(-t*x)]
% [                                 0]
% [               exp(-s*x)-exp(-t*x)]
% [                                 0]
% 
% H =
%  
% [                 c(j).*c(j+1).*t^2.*exp(-c(1).*t)]
% [                                 0]
% [                    -c(j+1).*t.*exp(-c(1).*t)]
% [                    -c(j).*t.*exp(-c(1).*t)]
% [ c(j).*t^2.*exp(-c(2).*t)-c(j).*c(j+1).*t^2.*exp(-c(2).*t)]
% [        -t.*exp(-c(2).*t)+c(j+1).*t.*exp(-c(2).*t)]
% [                     c(j).*t.*exp(-c(2).*t)]
% [                                 0]
% [               exp(-c(1).*t)-exp(-c(2).*t)]
% [                                 0]


%_________GRADIENT_______________

function [grad] = grad_dblexpconv(c, Data, IR, MODEL, D_err)

Nb_coef = length(c);
Nb_pix = (Nb_coef-2)/2;        %Number of pixels
T_points = size(Data,2);    %Number of time points
[Tmax, Tmax_i] = max(IR);  %finds Time zero indice
x = Data(1,:);
D = Data(2:Nb_pix+1,:);

t = x;
t(T_points+1) = t(T_points) + t(2) - t(1);
t = t - t(Tmax_i);

dF = zeros(Nb_coef, T_points + 1);
GdF = zeros(Nb_coef, 2*T_points - Tmax_i + 1);
grad = zeros(Nb_coef,1);

for j = 3:2:Nb_coef
    k = (j-1)/2;
    dF(1,:) = - c(j).*c(j+1).*t.*exp(-c(1).*t);
    dF(2,:) = - c(j).*t.*exp(-c(2).*t)+c(j).*c(j+1).*t.*exp(-c(2).*t);
    dF(j,:) = c(j+1).*exp(-c(1).*t)+exp(-c(2).*t)-c(j+1).*exp(-c(2).*t);
    dF(j+1,:) =  c(j).*exp(-c(1).*t)-c(j).*exp(-c(2).*t);
    
    GdF(1,:) = conv(IR,dF(1,Tmax_i:T_points+1));
    GdF(2,:) = conv(IR,dF(2,Tmax_i:T_points+1));
    GdF(j,:) = conv(IR,dF(j,Tmax_i:T_points+1));
    GdF(j+1,:) = conv(IR,dF(j+1,Tmax_i:T_points+1));
    
    Diff = (MODEL(k,:) - D(k,:))./D_err(k,:);
    grad(1) = grad(1) + sum(2.*GdF(1,1:T_points).*Diff);
    grad(2) = grad(2) + sum(2.*GdF(2,1:T_points).*Diff);
    grad(j) = sum(2.*GdF(j,1:T_points).*Diff);
    grad(j+1) = sum(2.*GdF(j+1,1:T_points).*Diff);
end




% G =
%  
% [                  -b*c*x*exp(-s*x)]
% [    -b*x*exp(-t*x)+b*c*x*exp(-t*x)]
% [ c*exp(-s*x)+exp(-t*x)-c*exp(-t*x)]
% [           b*exp(-s*x)-b*exp(-t*x)]
% 
% G =
%  
% [                  -c(j).*c(j+1).*t.*exp(-c(1).*t)]
% [    -c(j).*t.*exp(-c(2).*t)+c(j).*c(j+1).*t.*exp(-c(2).*t)]
% [ c(j+1).*exp(-c(1).*t)+exp(-c(2).*t)-c(j+1).*exp(-c(2).*t)]
% [           c(j).*exp(-c(1).*t)-c(j).*exp(-c(2).*t)]


%_________________conv_2D_________________

function F = conv_2D(decay_2D, IR)
% calculates the convolution between IR and each line of the decay matrix

Nb_pix = size(decay_2D,1);
T_points = length(IR);
F = zeros(Nb_pix,T_points);

for i = 1:T_points
    for k = 1:i
        F(:,i) = F(:,i) + IR(k).*decay_2D(:,i-k+1);
    end
end
