function multiplot( x, sz)
% Plot multiple vectors into one compact plot

% Paris Smaragdis, 2007, paris@media.mit.edu

% Cellify
if ~iscell( x)
	for i = 1:size( x, 1)
		X{i} = x(i,:);
	end
	x = X;
end
n = length( x);

% Default arrangement
if ~exist( 'sz')
	if n > 15
		sz = ceil(sqrt( length( x))) * [1 1];
	else
		sz = [n 1];
	end
end

% Find proper scaling
mx = 0;
for i = 1:n
	mx = max( mx, max( abs( x{i})));
end

% Plot them
cla reset
l = length( x{1});
for i = 1:n
	r = mod( i-1, sz(1));
	c = floor( (i-1)/sz(1));
	line( c*1.1*l + (1:l), 2*r + x{i}/max( abs(x{i})))
end
axis tight
