%%
% Extracting notes out of a monophonic passage
%
clear all

% Load a bar of piano music
s = wavread( 'bar1.wav')';

% Go to time-freq
f = stft( s, 1024, 128, 0, 'hann');

% Emphasize so high freqs matter a bit more
f = f .* repmat( linspace( 1, 10, size( f, 1))', 1, size( f, 2));

% Do analysis (use only significant lower frequencies)
plca2d( abs( f(1:200,:)), 4, 100, 0, 0, 0, [], [], [], 1);


%%
% Extracting notes out of a polyphonic passage
%
clear all

% Load two bars of (slightly) polyphonic piano music
s = wavread( 'bar12.wav')';

% Go to time-freq
f = stft( s, 1024, 128, 0, 'hann');

% Emphasize so high freqs matter a bit more
f = f .* repmat( linspace( 1, 10, size( f, 1))', 1, size( f, 2));

% Do analysis
plca2d( abs( f(1:200,:)), 9, 200, 0, 0, 0, [], [], [], 1);


%%
% Simple example of removing voice from music
% (fiddle with the settings and you can get near perfect separation)
%
clear all

% Load up some vintage Madonna
s = wavread( 'star-all.wav')';

% Go to time-freq
f = stft( s, 4096, 1024, 0, 'hann');
f1 = f(:,1:floor(end/2)); % first half no voice
f2 = f(:,ceil(end/2):end); % second half with voice

% Learn background model
b = 80;
[wb,hb,zb] = plca2d( abs( f1), b, 100, 0, 0, 0, [], [], [], 0);

% Learn foreground model given a background model and mixture
b2 = 120;
[w,h,z] = plca2d( abs( f2), b+b2, 200, 0, 0, 0, [], wb, [], 0, (b+1):(b+b2));

% Resynthesize latter half without voice
fn = abs( f2) ./ (w*diag(z)*h);
fp = f2 ./ abs( f2);
tf = (w(:,1:b)*diag(z(1:b))*h(1:b,:)) .* fn;
y = stft( tf.*fp, 4096, 1024, 0, 'hann');
soundsc( y, 44100)


%%
% Extracting components from a drum loop (using sparsity as well)
%
clear all

% Load up a drum loop
s = wavread( '80s.wav')';
soundsc( s, 11025)

% Go to time-freq
f = stft( s, 1024, 256, 0, 'hann');

% Emphasize so high freqs matter a bit more
f = f .* repmat( linspace( .5, 10, size( f, 1))', 1, size( f, 2));

% Do analysis
[w,h,z] = plca2d( abs( f), 5, 200, 0, 0, .02, [], [], [], 1);

% Resynthesize
fn = abs( f) ./ (w*diag(z)*h);
fp = f ./ abs( f);
fp = fp ./ repmat( linspace( .5, 10, size( f, 1))', 1, size( f, 2));
for i = 1:size( w, 2)
	tf = (w(:,i)*z(i)*h(i,:)) .* fn;
	y(i,:) = stft( tf.*fp, 1024, 256, 0, 'hann');
	soundsc( y(i,:), 11025)
end


%%
% Extracting multidimensional components
%
clear all

% Load an image of color handwritting
x = double( imread( 'colorletters.jpg'))/256;

% Resize so that we don't process all day
x = abs( imresize( x, 1/3));

% Find components (occasionally gets stuck in local optima)
cplca( x, 3, [20 20 3], [], [], [], 100, 0, 0, .5, 1, 1, 1, 1);
