#!/bin/bash
set -x
set -e
set -u
set -o pipefail
if [ -z "${1-}" ]
then set +x
echo "ERROR: Need number of metric megabytes as argument"
exit 1
fi

multiplier=$1
shift
date

# compress intermediate output to save space
unset BZIP2
bzipprogram=${bzipprogram-pbzip2}
$bzipprogram --version

# default block size of 512 bytes is sufficient
dd if=/dev/urandom count=1 of=testfile.myseed
./a.out filetodecimal testfile.myseed > testfile.myseed.decimal
#add newline manually. this is not strictly necessary but makes the output cleaner
echo >> testfile.myseed.decimal
cat testfile.myseed.decimal

totalsize=$(expr 1000000 \* $multiplier)
decimal=testfile.decimal.bz2
df .
cat /proc/swaps
./randdata4 $multiplier < testfile.myseed | command time ./a.out streamtodecimal $totalsize | $bzipprogram > $decimal

# average CPU usage of pbzip2 is boring because it initially waits for data

df .

# let load first decay to zero, for prettier xload graph
if [ -z "${nosleep-}" ]
then sleep 180
fi

wc -c $decimal
$bzipprogram -d -c $decimal | command time ./a.out decimaltobytes | md5sum | tee testfile.output.md5
rm $decimal
./randdata4 $multiplier < testfile.myseed | md5sum | tee testfile.input.md5
cmp testfile.input.md5 testfile.output.md5
date

# alternatively https://askubuntu.com/questions/1093843/how-to-split-input-to-two-pipes
