#!/bin/bash
set -x
set -e
set -u
set -o pipefail
totalsize=$(wc -c testfile.binary | awk '{print$1}')
command time ./a.out filetodecimal testfile.binary > testfile.decimal
command time ./a.out decimaltobytes < testfile.decimal > testfile.2
cmp testfile.binary testfile.2
( echo -n ' ' ; cat testfile.decimal ) | command time ./a.out decimaltobytes > testfile.2
cmp testfile.binary testfile.2

( cat testfile.decimal ; echo "" ) | command time ./a.out decimaltobytes > testfile.2
cmp testfile.binary testfile.2

( echo -n ' ' ; cat testfile.decimal ; echo "" ) | command time ./a.out decimaltobytes > testfile.2
cmp testfile.binary testfile.2

rm testfile.2

# fixedsizestream
command time ./a.out streamtodecimal $totalsize < testfile.binary > testfile.decimal.2
cmp testfile.decimal testfile.decimal.2

# unknownsizedstream
command time ./a.out streamtodecimal < testfile.binary > testfile.decimal.2
cmp testfile.decimal testfile.decimal.2

rm testfile.decimal testfile.decimal.2

true $0 all done
