#!/bin/sh
kit=`dirname $0`
rel="ocaml-3.09.1"
test -f "$kit/diffs" -a -f "$kit/emit64.mlp" || { echo "install script must be in directory with patches" 1>&2; exit 2; }
test -d "$rel" || { echo "install must be run from parent directory of $rel distribution" 1>&2; exit 3; }
set -e
echo "Patching files..."
patch -p0 < "$kit/diffs"
echo "Renaming asmrun/sparc.S"
mv -i "$rel/asmrun/sparc.S" "$rel/asmrun/sparc-default.S"
echo "Installing sparc-sparc64.S"
cp -p "$kit/sparc-sparc64.S" "$rel/asmrun/sparc-sparc64.S"
echo "Installing emit.mlp"
mv -i "$rel/asmcomp/sparc/emit.mlp" "$rel/asmcomp/sparc/emit.mlp.orig"
cp -pi "$kit/emit64.mlp" "$rel/asmcomp/sparc/emit.mlp"
echo "done"
