function t0 = tri_poly_pos_hamiltonian(x,tol)
% function t0 = tri_poly_pos_hamiltonian(x,tol)
%
% checking positivity of a trigonometric polynomial x by forming the
% Hamiltonian matrix
%
% x(t) = x(1) + x(2)*cos(t) + x(3)*cos(2*t) + ...

if nargin < 2
    tol = 1e-8;
end
x = x(:);
m = length(x)-1;    % order of the trigonometric polynomial
tol_eig = 1e-6;

% form the state space system employed in the KYP lemma
A = toeplitz([-1 ; 2*(-1).^(0:m-2)'],[-1 zeros(1,m-1)]);
B = (-1).^(0:m-1)';
C = [zeros(1,m) ; toeplitz(2*(-1).^(0:m-1)',[2 zeros(1,m-1)])];
D = (-1).^(0:m)';

% form the Hamiltonian matrix
S12 = 0.5*C'*x;
S21 = 0.5*x'*C;
S22 = x'*D-tol;
if S22 == 0
    t0 = pi;
    return;
end
H = [A-(B/S22)*S21 (B/S22)*B' ; (-S12/S22)*S21 -A'+(S12/S22)*B'];

% check positivity of x by checking eigenvalues of H on jw axis
%V = haeig(H);
V = eig(H);
[rmin,ind] = min(abs(real(V(1:m))));
%k = find(abs(real(V(1:m)))<sqrt(tol));
%tt0 = angle((1-j*imag(V(k)))./(1+j*imag(V(k))));
%[rmin,ind_k] = min(cos(tt0(:)*(0:m))*x);
%ind = k(ind_k);
if rmin > tol_eig
    t0 = [];
else
    t0 = angle((1-j*imag(V(ind)))/(1+j*imag(V(ind))));
end