function t0 = tri_poly_pos(x)
% function t0 = tri_polypos(x)
%
% check positivity of a trigonometric polynomial x of the form
% x(t) = x(1)+x(2)*cos(t)+x(3)*cos(2*t)+...
%
% if x(t) > 0 for all t in (0,pi), then output t0 = []
% otherwise return t0 such that x(t0) <= 0

x = x(:);
m = length(x)-1;

% first check the points (0,pi/2,pi) for positivity
if sum(x) <= 0
    t0 = 0;
elseif cos((0:m)*pi/2)*x <= 0
    t0 = pi/2;
elseif cos((0:m)*pi)*x <= 0
    t0 = pi;
else    % need to check real roots of x(t)
    P_matrix = tri_mul2pow(m); % first compute the conversion matrix from multiplicative form to power form
    P = x'*P_matrix; % form the corresponding ordinary polynomial w.r.t powers of cos(t)
    I = find_root_descarte(P,1); % first check real root in (0,1)
    if isempty(I)   % no root in (0,1)
        I = find_root_descarte((-1).^(0:m).*P,1);   % check real root in (-1,0)
        if ~isempty(I)  % has root in (-1,0)
            if polyval(P(end:-1:1),-I(1)) <= 0
                t0 = acos(-I(1));
            else
                t0 = acos(-I(2));
            end
        else
            t0 = [];
        end
    else    % has root in (0,1)
        if polyval(P(end:-1:1),I(1)) <= 0
            t0 = acos(I(1));
        else
            t0 = acos(I(2));
        end
    end
end