function P = tri_mul2pow(m)
% function P = tri_mul2pow(m)
%
% find the convertion matrix from cos(jx) to cos(x)^j from order 0 up to given order m
% P(i) --- coefficients of cos(x)^j up to i (in increasing order)
%          i.e. P(i,1)+P(i,2)*cos(x)+P(i,3)*cos(x)^2+...+P(i,i+1)*cos(x)^i


% first construct the triangle for values of combinations
C = zeros(m+1);
for ix = 1:(m+1)
    for ix1 = 1:ix
        if (ix1 == 1) | (ix1 == ix)
            C(ix,ix1) = 1;
        else
            C(ix,ix1) = C(ix-1,ix1-1)+C(ix-1,ix1);
        end
    end
end

P = diag([1 2.^(0:(m-1))]);
for j = 2:(m+1)
    for k = 1:floor((j-1)/2)
        P(j,j-2*k) = (-1)^k*(j-1)/k*C(j-k-1,k)*2^(j-2-2*k);
    end
end