function [sysr,xa,xb,xc,pp,qq,y] = run_ellip_rpn_BR(fr,t,m,r,W)
% function [sysr,xa,xb,xc,pp,qq,y] = run_ellip_rpn_BR(fr,t,m,r,W)
%
% master file for running ellip_rpn.m (bounded real version)
% Inputs:
% fr --- frequency response of the original system
% t --- frequency samples corresponding to fr
% m --- order of the reduced system
% r --- desired value of relative tolerance (default = 0.9)
% W --- vector of weight of length t to modify the solution (default = ones(length(t),1)

if nargin < 4
    r = 0.9;
end
if nargin < 5
    W = ones(length(t),1);
else
    W = W(:);
end

% convert variables to column vector
fr = fr(:);
t = t(:);
nt = size(t,1);

% build some necessary matrices
h = (4*m+2)*max(abs(fr));
x0 = zeros(3*m+1,1);                     % initial guess: a(t)==1, b(t)==0
H0 = diag(repmat(sqrt(12*m+1),1,3*m+1)); % initial ellipsoid
fn = fr/h;                              % normalized samples as a column vector

Tc = cos(t*(0:m));
Ts = sin(t*(1:m));
p = [repmat(fn,1,m+1).*Tc -Tc -j*Ts];
q = [Tc zeros(nt,2*m+1)]./repmat(W,1,3*m+2);
max_iter = 200000;

[x,y,LBhist] = ellip_abc_BR_rpn(p,q,h,H0,x0,r,max_iter);

% extract the result
x = real(x);
xa = x(1:m);
xb = x(m+1:2*m+1)*h;
xc = x(2*m+2:3*m+1)*h;
qq = compute_q(xa);
pp = compute_p1w_BR(t,fr,qq,W);
sysr = tf(pp,qq,-1);
y = y*h;