function [L,ds] = obj_cut(p,q,x,y)
% function [L,ds] = obj_cut(p,q,x,y)
%
% if ds = -1, F(x) < y and no objective cut is returned. Otherwise, return
% a cut L(xx-x) >= ds, where ds >= 0 and xx in R^n

n = length(x);
m = floor(n/3);
num_minus_den = abs(p*[1;x]) - y*(q*[1;x]);
[num_minus_den_max,max_ind] = max(num_minus_den);
if num_minus_den_max < 0    % x has obj value < y
    L = zeros(1,n);
    ds = -1;
    max_ind = 0;
else    % x has obj value >= y (can add deep or netural cut)
    pm = real(p(max_ind,:)*conj(sign(p(max_ind,:)*[1 ; x])));
    L = y*q(max_ind,2:n+1)-pm(2:n+1);
    ds = pm(1)-y*q(max_ind,1)-L*x;
    if ds < 0
        ds = 1e-14;
    end
end