function [y,x]=lfo_linear_opt(p,q,x1,x2,N)
% function [y,x]=lfo_linear_opt(p,q,x1,x2,N)
%
% minimize F(x)=max abs(p*[1;x])./(q*[1;x]) on [x1,x2], 
% assuming q*[1;x]>0 on[x1;x2], using N iterations of binary search
% default N=7

if nargin<5, N=7; end
n=length(x1);

u=x2-x1;
tmin=0;
tmax=1;
p0=p*[1;x1];
p1=p(:,2:n+1)*u;
q0=q*[1;x1];
q1=q(:,2:n+1)*u;
x=x1;
y=max(abs(p0)./q0);
topt=0;
for k=1:N,
    t=0.5*(tmin+tmax);
    [yy,k]=max(abs(p0+t*p1)./(q0+t*q1));
    if yy<y,
        x=x1+t*u;
        y=yy;
        topt=t;
    end
    der=(real(p0(k)'*p1(k))+p1(k)'*p1(k))*(q0(k)+q1(k)*t)-q1(k)*abs(p0(k)+p1(k)*t)^2;
    if der>=0,
        tmax=t;
    else
        tmin=t;
    end
end
%topt
    
%if topt==0,
%    tt=linspace(0,1,1000);
%    mx=zeros(1,1000);
%    for k=1:1000,
%        mx(k)=max(abs(p0+tt(k)*p1)./(q0+tt(k)*q1));
%    end
%    close(gcf);plot(tt,mx); grid
%    pause
%end

