function I = find_root_descarte(P,b)
% function I = find_root_descarte(P,b)
%
% find an interval I containing a single positive real root or verify that
% such I does not exist (i.e. P does not have any positive real root)
%
% P is in ascending order
% b is an real root bound (i.e. |z|<b for all real root z)

m = length(P)-1;
P = P(:);

% find real root bound if necessary
if nargin < 2
    b = root_bound(P);
end

k = log2(b);
if k >= 0
    A_star = P.*(2.^((0:m)*k)');
else
    A_star = 2^(-k*m)*(P.*(2.^((0:m)*k)'));
end
A_star_nozero = A_star(find(A_star));
var_A_star = sum(abs(diff(A_star_nozero>0)));
if var_A_star == 0
    I = [];
    return;
elseif var_A_star == 1
    I = [0 b];
    return;
else
    L = [A_star' 0 b];
end

% compute the binomial coefficients first
C = zeros(m+1);
for ix = 1:(m+1)
    for ix1 = 1:ix
        if (ix1 == 1) | (ix1 == ix)
            C(ix,ix1) = 1;
        else
            C(ix,ix1) = C(ix-1,ix1-1)+C(ix-1,ix1);
        end
    end
end

while size(L,1) > 0
    Ai = L(1,1:m+1)';
    Ii = L(1,m+2:m+3);
    L = L(2:end,:); % dequeue the current pair (A_i,(a_i,b_i))
    %Ai_star = sum(repmat(Ai(end:-1:1),1,m+1).*C);
    Ai_star = C'*Ai(end:-1:1);
    Ai_star_nozero = Ai_star(find(Ai_star));
    var_Ai_star = sum(abs(diff(Ai_star_nozero)));
    if var_Ai_star == 1
        I = Ii;
        return;
    else
        Ai_p = Ai.*(2.^(m:-1:0)');
        %Ai_p_star = sum(repmat(Ai_p(end:-1:1),1,m+1).*C)';
        Ai_p_star = C'*Ai_p(end:-1:1);
        Ai_p_star_nozero = Ai_p_star(find(Ai_p_star));
        var_Ai_p_star = sum(abs(diff(Ai_p_star_nozero>0)));
        if var_Ai_p_star == 1
            I = [Ii(1) mean(Ii)];
            return;
        elseif var_Ai_p_star >= 2
            L = [[Ai_p' Ii(1) mean(Ii)] ; L];
        end
        %Ai_dp = sum(repmat(Ai_p,1,m+1).*C)';
        Ai_dp = C'*Ai_p;
        if Ai_dp(1) == 0
            I = [mean(Ii) mean(Ii)];
            return;
        end
        %Ai_dp_star = sum(repmat(Ai_dp(end:-1:1),1,m+1).*C)';
        Ai_dp_star = C'*Ai_dp(end:-1:1);
        Ai_dp_star_nozero = Ai_dp_star(find(Ai_dp_star));
        var_Ai_dp_star = sum(abs(diff(Ai_dp_star_nozero>0)));
        if var_Ai_dp_star == 1
            I = [mean(Ii) Ii(2)];
            return;
        elseif var_Ai_dp_star >= 2
            L = [[Ai_dp' mean(Ii) Ii(2)] ; L];
        end
    end
end

% no positive real root is found is the code reaches here
I = [];