function [Hn,x0n]=ellips_cut1(H,x0,L,r)
% function [Hn,x0n]=ellips_cut1(H,x0,L,r)
% 
% finds a minimum-volume ellips {x: |inv(Hn)(x-x0n)|<1} containing the
% intersection of ellips {x: |inv(H)(x-x0)|<1} with the half-plane
% {x: L(x-x0)>r*|LH|}, where r is between 0 and 1.

%disp(['*********   r=' num2str(r)])
    
n=length(x0);
LH=L*H;
q=norm(LH);
p=q^2;
ptau=2*(1+r*n)/((1-r)*(n-1));
tau=ptau/p;
theta = (1-1/sqrt(1+ptau))/p;
%D = (1+ptau/2*(1-r))/sqrt(1+ptau);
D = sqrt((1-r^2)*n^2/(n^2-1));
%x0n = x0 + tau/2*(1+r)*q/(1+ptau)*(H*LH');
x0n = x0 + (n*r+1)/(n+1)/q*(H*LH');
Hn = D*(H-theta*(H*LH')*LH);