function demo_ansoft_2008
% function demo_ansoft_2008
%
% Demonstration of how the QCO code (bounded real passive version) works
%
% Figure 1 shows the matching (magnitude and phase) of S parameter example 1
% Figure 2 shows the matching (magnitude and phase) of S parameter example 2
%
% Order of reduced model 1 is 10
% Order of reduced model 2 is 20
%
% It takes a while to generate the reduced models

load ansoft_2008;
addpath ../

% find "optimal" center frequencies for C2D transform, and compute DT
% frequency samples
f10 = find_center_frequency(f1,data1); % 1e9 is not bad
f20 = find_center_frequency(f2,data2); % 1e6 is not bad
t1 = 2*atan(f1/f10); % DT frequency for case 1
t2 = 2*atan(f2/f20); % DT frequency for case 2

% generate reduced models
m1 = 10; % ROM order, by trial
m2 = 20; % ROM order, by trial

% case 1
disp('generating reduced model for case 1');
sys1 = run_ellip_rpn_BR(data1,t1,m1); % generate ROM
G1 = squeeze(freqresp(sys1,t1)); % frequency response
figure(1);
subplot(211);
plot(f1,abs(data1),f1,abs(G1));
legend('measured','QCO');
xlabel('f (Hz)');
ylabel('magnitude');
subplot(212);
plot(f1,angle(data1),f1,angle(G1));
legend('measured','QCO');
xlabel('f (Hz)');
ylabel('phase');

% case 2
disp('generating reduced model for case 2');
sys2 = run_ellip_rpn_BR(data2,t2,m2); % generate ROM
G2 = squeeze(freqresp(sys2,t2)); % frequency response
figure(2);
subplot(211);
plot(f2,abs(data2),f2,abs(G2));
legend('measured','QCO');
xlabel('f (Hz)');
ylabel('magnitude');
subplot(212);
plot(f2,angle(data2),f2,angle(G2));
legend('measured','QCO');
xlabel('f (Hz)');
ylabel('phase');