function demo_ansoft_2005
% function demo_ansoft_2005
%
% Demonstration of how the QCO code (bounded real passive version) works
% Figure shows the matching of the magnitude of S parameter S11
% Reduced model order is 20
%
% It takes a while to generate the reduced model

load ansoft_2005
addpath ../

% find "optimal" center frequencies for C2D transform, and compute DT
% frequency samples
G = squeeze(S(1,1,:));
f0 = find_center_frequency(f,G);
t = 2*atan(f/f0); % DT frequency

% generate ROM
m = 20; % order of ROM
r = 0.9; % parameter for ellipsoid method termination

% weight for frequency response matching (by trial)
W = linspace(1,0,length(f)).^2;

disp('generating reduced model ...');
sys = run_ellip_rpn_BR(G,t,m,r,W); % generate ROM
G1 = squeeze(freqresp(sys,t)); % frequency response
figure(1); plot(f,abs(G),f,abs(G1));
xlabel('f (Hz)');
ylabel('|S11|');
legend('original','ROM');