function q = compute_q(a)
% function q = compute_q(a)
% compute q(z) from a(z)
% a(z) is in increasing order and is normalized i.e. a(z) = 1 + a1*cos(t) + a2*cos(2t) + ...
% q(z) is in decreasing order

if size(a,1) > size(a,2)
    a = a.';
end
m = length(a);              % model reduction parameter (m)
r = max(find(a));       % order of the trigonometric polynominal
    % find the ordinary polynominal a(z) 
az = [0.5*a(r:-1:1) 1 0.5*a(1:r)];  % a(z) = 1 + .5*(a1*z + a1/z) + .5*(a2*z^2 + a2/z^2) + ...
Z = roots(az);              % zeros of a(z)
Zs = Z(abs(Z) < 1);         % zeros of a(z) inside unit circle
q0 = az(1) / real(prod(-Zs));
qr = poly(Zs);
q = sqrt(q0)*[qr zeros(1,m-r-1)];