function R = RE_f(b,a,t,type)
% function R = RE_f(b,a,t,type)
% R is real part of rational transfer function (RE(G(z)) = RE(p(z)/q(z)) =
% (b(z)/a(z))
% b is b(z), the numerator in increasing order
% a is a(z), the denominator in increasing order
% t is the vector of angles (i.e. z = exp(i*t)
% type = 1 --- cos trigonometric polynomial; type = 2 --- z trigonometric polynomial
% default is type 1
%
% for type 1, a(t) = a(1)+a(2)*cos(t)+...+a(m)*cos((m-1)*t)
% for type 2, a(z) = a(1)+a(2)*(z+1/z)+...+a(m)*(z^m+1/z^m)

if nargin < 4
    type = 1;
end

% convert to row vector
a = a(:)';
b = b(:)';

m = length(a); % assume length(a) = length(b)
nT = length(t); % mumber of samples of DT frequency

R = zeros(nT,1); 
if type == 1
    for i = 1:nT
        R(i) = (b * cos(t(i)*(0:m-1)*1)') / (a * cos(t(i)*(0:m-1)*1)');
    end
elseif type == 2
    for i = 1:nT
        R(i) = (b*[1 2*cos((1:m-1)*t(i))]') / (a*[1 2*cos((1:m-1)*t(i))]');
    end
else
    error('Type error!');
end