function I = IM_f(c,a,t,type)
% function I = IM_f(c,a,t,type)
% I is imaginary part of rational transfer function (IM(G(z)) = IM(p(z)/q(z)) =
% (c(z)/a(z))
% c is c(z), the numerator in increasing order
% a is a(z), the denominator in increasing order
% t is the vector of angles (i.e. z = exp(i*t)
% type = 1 --- cos trigonometric polynomial; type = 2 --- z trigonometric polynomial
% default is type 1

if nargin < 4
    type = 1;
end

% convert to row vector
a = a(:)';
c = c(:)';

m = length(a); % assume length(a) = length(b)
nT = length(t); % number of DT frequency samples

I = zeros(nT,1);
if type == 1
    for i = 1:nT
        I(i) = (c * sin(t(i)*(1:m-1)*1)') / (a * cos(t(i)*(0:m-1)*1)');
    end
elseif type == 2
    for i = 1:nT
        I(i) = (c*2*sin(t(i)*(1:m-1))') / (a*[1 2*cos(t(i)*(1:m-1))]');
    end
else
    error('Type error!');
end