## a function for backing out the most frequent non-stemmed word associated with a stem
## Assumes that arabicStemR is loaded.
## Rich Nielsen
## 3/22/2019

reverseStem <- function(stemmedWord, stemListHolder){
  ## transliterate to arabic if necessary
  if(length(grep("[A-Za-z0-9]",stemmedWord))>0){stemmedWord <- reverse.transliterate(gsub("X","",stemmedWord))}
  holder <- c()
  for(i in 1:length(stemListHolder)){
    #if(i%%1000 == 0){print(i)}
    holder <- c(holder,stemListHolder[[i]][stemListHolder[[i]] %in% stemmedWord])
  }
  return(names(rev(sort(table(names(holder))))[1]))
}

